/****************************************************************************************
 *                                                                                      *
 * PROGRAM - Demonstration of the RTI interrupt to toggle the GB60 EVB LED1 periodically*
 *                                                                                      *
 * VERSION - Ver 1.1                                                                    *
 *                                                                                      *
 * Author  - Steven McLaughlin                                                          *
 *                                                                                      *  
 * DATE    - August 2007                                                              *
 *                                                                                      *
 ****************************************************************************************/
 
/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2006 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       main.c               											
*														              					
* Description:	     	       						
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  FREESCALE CW COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM            *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/	  

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include <MC9S08GB60.h>

/************************************Prototypes*******************************************/
extern void init_ICG (void);
extern void vector (void);


/*************************************DEFINES*********************************************/
/*COMMON BIT DEFINITIONS*/
#define BIT0 0x01
#define BIT1 0x02
#define BIT2 0x04
#define BIT3 0x08
#define BIT4 0x10
#define BIT5 0x20
#define BIT6 0x40
#define BIT7 0x80


/* DEFINES FOR CHANGES STATUS OF LEDS*/
#define SWITCH_OFF 1
#define SWITCH_ON 0

/*INIT LEDS FOR GB60DEMO EVB*/
#define init_LED()   PTFDD        = (BIT3|BIT2|BIT1|BIT0);/* Set Port F bit0-3 as output */\
                     PTDDD_PTDDD0 = 1;                    /* Set Port D bit0 as output   */\
                     PTDD_PTDD0   = SWITCH_OFF;           /* Switch off LED 5            */\
                     PTFD         = (BIT3|BIT2|BIT1|BIT0) /* Switch off LED 1-4          */
                   
/* definition of the LED macros */
#define LED1 PTFD_PTFD0
#define LED2 PTFD_PTFD1
#define LED3 PTFD_PTFD2
#define LED4 PTFD_PTFD3
#define LED5 PTDD_PTDD0

/************************************ FUNCTIONS ****************************************/

/***************************************************************************************
 *                                                                                     *
 *  FUNCTION - Main                                                                    *
 *                                                                                     *
 *  DESCRIPTION - Setup registers                                                      *
 *              - Blink LED1 in time with RTI                                          *                                     *
 *                                                                                     *
 *  RETURNS     - None                                                                 *
 **************************************************************************************/
                  
      
void main(void) {
  
  
  /*initiate ICG clock*/
  init_ICG();
  
  /*initaite LEDs*/
  init_LED(); 
  
  /****************************SYSTEM OPTION REGSITER (SOPT)******************************
  
        
         BIT7  |   BIT6  |   BIT5   |  BIT4    |   BIT3   |  BIT2   |  BIT1   |  BIT0 
        ------------------------------------------------------------------------------
       | COPE  |   COPT  |   STOPE  |    1     |     0    |    0    |  BKGDPE |    1  |
        ------------------------------------------------------------------------------
       |   0   |    1    |    1     |    0     |     0    |    0    |    1    |    0  |
        ------------------------------------------------------------------------------
        
       COPE=0;   COP WATCHDOG TIMER DISABLED
       COPT=1;   LONG TIMEOUT PERIOD (2^18)
       STOPE=1;  STOP MODE ENABLED
       BKGDPE=1; BKGD PIN DISABLED
       
   ***************************************************************************************/     
  
    SOPT = 0b01100010;
    
  
  /****************SYSTEM POWER MANAGEMENT STATUS & CONTROL REGISTER 1 (SPMSC1)***********
  
    
         BIT7  |   BIT6  |   BIT5   |  BIT4    |   BIT3   |  BIT2   |  BIT1   |  BIT0 
        ------------------------------------------------------------------------------
       | LVDF  |  LVDACK |   LVDIE  |  LVDRE   |   LVDSE  |  LVDE   |    0    |    0  |
        ------------------------------------------------------------------------------
       |   0   |    0    |    1     |    0     |     1    |    1    |    0    |    0  |
        ------------------------------------------------------------------------------ 
        
       LVDF=0;   READ ONLY STATUS BIT INDICATING LOW VOLTAGE DETECT
       LVDACK=0; WRITE ONLY BIT TO ACK LOW VOLT DETECT ERRORS
       LVDIE=1;  REQUEST H/W INTERRUPT 
       LVDRE=0;  LVDF DOES NOT GENERATE H/W RESETS
       LVDSE=1;  LOW VOLT DETECT ENABLED DURING STOP
       LVDE=1;   LVD LOGIC ENABLED 
                                        
   **************************************************************************************/
   
   SPMSC1=0b00101100;
   
     /****************SYSTEM POWER MANAGEMENT STATUS & CONTROL REGISTER 2 (SPMSC2)***********
  
    
         BIT7  |   BIT6  |   BIT5   |  BIT4    |   BIT3   |  BIT2   |  BIT1   |  BIT0 
        ------------------------------------------------------------------------------
       | LVWF  |  LVWACK |   LVDV   |  LVWV    |   PPDF   |  PPDACK |    PDC  |  PPDC |
        ------------------------------------------------------------------------------
       |   0   |    0    |    1     |    1     |     0    |    0    |    1    |    X  |
        ------------------------------------------------------------------------------ 
        
       LVWF=0; LOW VOLTAGE WARNING NOT PRESENT
       LVWACK=0; 
       LVDV=1; LOW TRIP POINT SELECTED
       LVWV=1; HIGH TRIP POINT SELECTED
       PPDF=0; NOT STOP2 MODE RECOVERY
       PPDACK=0; 
       PDC=1; POWER DOWN MODES ARE ENABLED (0 for STOP3)
       PPDC=1;STOP2, FULL PWR DOWN (WRITE ONCE) (X for STOP3)
                                        
   **************************************************************************************/
   
   SPMSC2=0b00110011;
   
   /********************SYSTEM RTI STATUS & CONTROL REGISTER (SRTISC)********************
  
    
         BIT7  |   BIT6  |   BIT5   |  BIT4    |   BIT3   |  BIT2   |  BIT1   |  BIT0 
        ------------------------------------------------------------------------------
       | RTIF  |  RTIACK |  RTICLKS |  RTIE    |     0    |  RTIS2  |  RTIS1  |  RTIS0 |
        ------------------------------------------------------------------------------
       |   0   |    0    |    1     |    1     |     0    |    1    |    1    |    1   |
        ------------------------------------------------------------------------------ 
        
       RTIF=0;    (READ ONLY) PERIODIC WAKE-UP TIMER NOT TIMED OUT 
       RTICLKS=1; REAL TIME INTERRUPT REQUEST CLOCK SOURCE IS EXTERNAL
       RTIE=1;    REAL TIME INTERRUPTS ENABLED
       RTIS2:RTIS1:RTIS0 = 1:1:1  INTERRUPT PERIOD ENABLED (external source)
                                        
   **************************************************************************************/
   
     SRTISC=0b00110111;
   
   
   EnableInterrupts; /* enable interrupts */
      

  for(;;) {
           
           
              __RESET_WATCHDOG(); /* feeds the dog */
         } /* loop forever */
  
  }
  
  /* please make sure that you never leave main */
  /***************************************************************************
 * Interrupt :   RTI_ISR
 *
 * Description: RTI interrupt
 *
 * Returns:     none
 *
 * Notes:       clear flags
 *              toggle LED1
 **************************************************************************/
interrupt void RTI_ISR( void )
{
/* clear RTI flag */
SRTISC_RTIACK = 1;

/*clear partial power down flag*/
SPMSC2_PPDACK = 1;

/* toggle LED1 */
LED1 = ~ LED1;
	
}

